-- RecorridoEnAnchura.hs
-- Recorrido en anchura
-- José A. Alonso Jiménez <jalonso@us.es>
-- Sevilla, 2 de Noviembre de 2010
-- ---------------------------------------------------------------------

module RecorridoEnAnchura where

-- ---------------------------------------------------------------------
-- Librerías auxiliares                                               --
-- ---------------------------------------------------------------------

-- Nota: Elegir una implementación de los grafos.
import GrafoConVectorDeAdyacencia
-- import GrafoConMatrizDeAdyacencia

-- Nota: Elegir una implementación de las colas
import ColaConListas
-- import ColaConDosListas

-- ---------------------------------------------------------------------
-- Ejemplo de grafo                                                   --
-- ---------------------------------------------------------------------

-- g es el grafo
--    +---> 2 <---+
--    |           |
--    |           |
--    1 --> 3 --> 6 --> 5
--    |                 |
--    |                 |
--    +---> 4 <---------+
g = creaGrafo True (1,6) 
              [(1,2,0),(1,3,0),(1,4,0),(3,6,0),(5,4,0),(6,2,0),(6,5,0)]

-- ---------------------------------------------------------------------
-- Recorrido en anchura con colas                                      --
-- ---------------------------------------------------------------------

-- (recorridoEnAnchura i g) es el recorrido en anchura del grafo g
-- desde el vértice i, usando colas. Por ejemplo, 
--    recorridoEnAnchura 1 g  ==  [1,4,3,2,6,5]
recorridoEnAnchura i g = reverse (ra (inserta i vacia) [])
 where
  ra q vis 
   | esVacia q = vis
   | elem (primero q) vis = ra (resto q) vis
   | otherwise  = ra (foldr inserta (resto q) (adyacentes g c))
                     (c:vis)
                  where c = primero q
