﻿/* $Id: I2L_problems.j,v 1.10 2003/10/08 09:05:53 richard Exp $ */

TACTIC TheoremForward (thm) IS CUTIN (ALT thm (RESOLVE thm))

TACTIC TheoremForwardOrBackward(thm) IS
    WHEN    
        (LETHYP _A 
            (ALT    (TheoremForward (WITHHYPSEL (WITHARGSEL thm)))))
        (LETHYPS _As
            (Fail ("At present I2L Jape can't deal with multiple antecedent selections when applying theorems. Sorry.\
                    \\nCancel one of them and try again.")))
        (LETGOAL _A
            (ALT (WITHARGSEL thm) 
                (RESOLVE (WITHARGSEL thm)) 
                (TheoremForward (WITHARGSEL thm))
                (Fail   "Theorem application failed -- tell Richard")))
        (LETOPENSUBGOAL G _A 
            (Fail ("Error in I2L Jape (open subgoal in TheoremForwardOrBackward). Tell Richard.")))
        (LETOPENSUBGOALS _As
            (ALERT  ("There is more than one unproved conclusion in the proof. Please select one – \
                        \or select an antecedent – to show \
                        \Jape where to apply the theorem.")
                    ("OK", STOP) 
                    ("Huh?", Explainantecedentandconclusionwords)))
        (ALERT  "The proof is finished -- there are no unproved conclusions left."
                ("OK", STOP) 
                ("Huh?", Explainunprovedconclusionwords))

/* These theorems are all stated without an explicit left context Γ. That is possible because, in I2L_rules.j,
 * we declared a WEAKEN structure rule: Jape will automatically discard any unmatched left-context
 * formulae.
 */
  
/* Panels are declared in reverse order because the GUIs,  quite reasonably, create panels in the order requested.
 * Thus the last you ask for is the last created, and appears at the front of the stack.
 */

CONJECTUREPANEL "Ejemplos proposicionales"
   
 /* Reglas de la conjunciÛn */
 /* E01 p.  7 */ THEOREM INFER p ∧ q, r ⊦ q ∧ r              
 
 /* Reglas de la doble negaciÛn */
 /* E02 p.  9 */ THEOREM INFER p, ¬¬(q ∧ r) ⊦ ¬¬p ∧ r        
 /* E03 p.  9 */ /* THEOREM INFER (p ∧ q) ∧ r, s ∧ t ⊦ q ∧ s */
 
 /* Regla de eliminaciÛn del condicional */
 /* E04 p. 10 */ THEOREM INFER ¬p ∧ q, ¬p ∧ q → r ∨ ¬p ⊦ r ∨ ¬p    
 /* E05 p. 11 */ THEOREM INFER p, p → q, p → (q → r) ⊦ r
 /* E06 p. 11 */ THEOREM INFER p → (q → r), p, ¬r ⊦ ¬q    
 /* E07 p. 12 */ THEOREM INFER ¬p → q, ¬q ⊦ p    
 /* E08 p. 12 */ THEOREM INFER p → ¬q, q ⊦ ¬p

 /* Regla de introducciÛn del condicional */    
 /* E09 p. 13 */ THEOREM INFER p → q ⊦ ¬q → ¬p    
 /* E10 p. 14 */ THEOREM INFER ¬q → ¬p ⊦ p → ¬¬q   
 /* E11 p. 15 */ THEOREM INFER ⊦ p → p    
 /* E12 p. 15 */ THEOREM INFER ⊦ (q → r) → ((¬q → ¬p) → (p → r))    
 /* E13 p. 17 */ THEOREM INFER p ∧ q → r ⊦ p → (q → r)    
 /* E14 p. 18 */ THEOREM INFER p → (q → r) ⊦ (p ∧ q) → r    
 /* E15 p. 18 */ THEOREM INFER p → q ⊦ p ∧ r → q ∧ r    

 /* Reglas de la disyunciÛn */
 /* E16 p. 20 */ THEOREM INFER p ∨ q ⊦ q ∨ p    
 /* E17 p. 20 */ THEOREM INFER q → r ⊦ p ∨ q → p ∨ r    
 /* E18 p. 21 */ THEOREM INFER (p ∨ q) ∨ r ⊦ p ∨ (q ∨ r)    
 /* E19 p. 21 */ THEOREM INFER p ∧ (q ∨ r) ⊦ (p ∧ q) ∨ (p ∧ r)    

 /* Regla de copia */
 /* E20 p. 22 */ THEOREM INFER ⊦ p → (q → p)    

 /* Reglas de la negaciÛn */
 /* E21 p. 25 */ THEOREM INFER ¬p ∨ q ⊦ p → q    
 /* E22 p. 25 */ THEOREM INFER p → q, p → ¬q ⊦ ¬p    
 /* E23 p. 26 */ THEOREM INFER p → ¬p ⊦ ¬p   
 /* E24 p. 26 */ THEOREM INFER p ∧ ¬q → r, ¬r, p ⊦ q    
 /* E25 p. 26 */ THEOREM INFER p → (q → r), p, ¬r ⊦ ¬q   

/* Reglas del bicondicional */
/* E31 */ THEOREM INFER p ∧ q ↔ q ∧ p 
/* E32 */ THEOREM INFER p ↔ q, p ∨ q  ⊦ p ∧ q

 /* Reglas derivadas */
 /* E26 p. 28 */ THEOREM INFER F → G, ¬G ⊦ ¬F    
 /* E27 p. 28 */ THEOREM INFER F ⊦ ¬¬F    
 /* E28 p. 29 */ THEOREM INFER ¬F → ⊥ ⊦ F   
 /* E29 p. 30 */ THEOREM INFER ⊦ F ∨ ¬F    
 /* E30 p. 30 */ THEOREM INFER p → q ⊦ ¬p ∨ q    
 
 BUTTON Apply IS apply TheoremForwardOrBackward COMMAND
END

