﻿/* $Id: I2L_problems.j,v 1.10 2003/10/08 09:05:53 richard Exp $ */

TACTIC TheoremForward (thm) IS CUTIN (ALT thm (RESOLVE thm))

TACTIC TheoremForwardOrBackward(thm) IS
    WHEN    
        (LETHYP _A 
            (ALT    (TheoremForward (WITHHYPSEL (WITHARGSEL thm)))))
        (LETHYPS _As
            (Fail ("At present I2L Jape can't deal with multiple antecedent selections when applying theorems. Sorry.\
                    \\nCancel one of them and try again.")))
        (LETGOAL _A
            (ALT (WITHARGSEL thm) 
                (RESOLVE (WITHARGSEL thm)) 
                (TheoremForward (WITHARGSEL thm))
                (Fail   "Theorem application failed -- tell Richard")))
        (LETOPENSUBGOAL G _A 
            (Fail ("Error in I2L Jape (open subgoal in TheoremForwardOrBackward). Tell Richard.")))
        (LETOPENSUBGOALS _As
            (ALERT  ("There is more than one unproved conclusion in the proof. Please select one – \
                        \or select an antecedent – to show \
                        \Jape where to apply the theorem.")
                    ("OK", STOP) 
                    ("Huh?", Explainantecedentandconclusionwords)))
        (ALERT  "The proof is finished -- there are no unproved conclusions left."
                ("OK", STOP) 
                ("Huh?", Explainunprovedconclusionwords))

/* These theorems are all stated without an explicit left context Γ. That is possible because, in I2L_rules.j,
 * we declared a WEAKEN structure rule: Jape will automatically discard any unmatched left-context
 * formulae.
 */
  
/* Panels are declared in reverse order because the GUIs,  quite reasonably, create panels in the order requested.
 * Thus the last you ask for is the last created, and appears at the front of the stack.
 */

CONJECTUREPANEL "Ejemplos LPO"
   
 /* Reglas del generalizador */
 /* E01 p. 114 */ THEOREM INFER actual y, P(y),∀x.(P(x)→¬ Q(x)) ⊦ ¬Q(y) 
 /* E02 p. 114 */ THEOREM INFER ∀x.(P(x) → Q(x)), ∀x.P(x) ⊦ ∀x.Q(x)
 
 /* Reglas del particularizador */

 /* E03 p. 117 */ THEOREM INFER actual j, ∀x.P(x) ⊦ ∃x.P(x)
 /* E04 p. 117 */ THEOREM INFER ∀x.(P(x) → Q(x)), ∃x.P(x) ⊦ ∃x.Q(x)
 /* E05 p. 118 */ THEOREM INFER ∀x.(Q(x) → R(x)), ∃x.(P(x) ∧ Q(x)) ⊦ ∃x.(P(x) ∧ R(x))
 /* E06 p. 119 */ THEOREM INFER ∃x.P(x), ∀x.∀y.(P(x) → Q(y)) ⊦ ∀y.Q(y)

 /* Equivalencias */
 /* E07 p. 123 */ THEOREM INFER ¬(∀x.P(x)) ⊦ ∃x.¬P(x)
 /* E08 p. 123 */ THEOREM INFER ∃x.¬P(x) ⊦ ¬(∀x.P(x)) 
 /* E09 p. 123 */ THEOREM INFER ⊦ ¬(∀x.P(x)) ↔ ∃x.¬P(x)
 /* E10 p. 124 */ THEOREM INFER ∀x.(P(x) ∧ Q(x)) ⊦ ∀x.P(x) ∧ ∀x.Q(x)
 /* E11 p. 124 */ THEOREM INFER ∀x.P(x) ∧ ∀x.Q(x) ⊦ ∀x.(P(x) ∧ Q(x))
 /* E12 p. 124 */ THEOREM INFER ⊦ ∀x.(P(x) ∧ Q(x)) ↔ ∀x.P(x) ∧ ∀x.Q(x)
 /* E13 p. 117 */ THEOREM INFER ∃x.P(x) ∨ ∃x.Q(x) ⊦ ∃x.(P(x) ∨ Q(x))
 /* E14 p. 117 */ THEOREM INFER ∃x.(P(x) ∨ Q(x)) ⊦ ∃x.P(x) ∨ ∃x.Q(x)
 /* E15 p. 117 */ THEOREM INFER ⊦ ∃x.P(x) ∨ ∃x.Q(x) ↔ ∃x.(P(x) ∨ Q(x))
 /* E16 p. 117 */ THEOREM INFER ∃x.∃y.P(x,y) ⊦ ∃y.∃x.P(x,y)
 /* E17 p. 117 */ THEOREM INFER ⊦ ∃x.∃y.P(x,y) ↔ ∃y.∃x.P(x,y)

 BUTTON Apply IS apply TheoremForwardOrBackward COMMAND
END
